 aR  w Q mP9      h	 oP       nSystem-wide    NAME CpInit

; This is cp.init.asm~text~
; This module contains all hardware dependent
; routines for Compass Central Prom initialization

$SAVE NOLIST
$INCLUDE (`w`CcProm`Cp.Constant.Asm.Inc~Text~)
$RESTORE

; djm - added
%SET (notUsed, 1)

; djm 1/5/85.
; The following test was added to determine why gpib was not working
; when FastBoot was used. Turns out to be result of not initializing 
; the prom variables to 0. GPiB Driver expects variables to be initialized
; when ddInit is called. See InitGPiBVariable for details.
%SET (TestGPiB, 0)
; djm - end

CGROUP GROUP CODE
DGROUP GROUP DATA


    PUBLIC CpKeyPressed, CpCharIn, CpCharOut
 
    PUBLIC ConCharOut, ConLineOut, diag8274Exists
    PUBLIC Continue_Init

    EXTRN  CompassPromStart: FAR
    EXTRN  CpDelay1Millisecond: NEAR
    EXTRN  consoleSeg: WORD

; djm - added
    EXTRN  fixedCardInfo: WORD, fixedVersInfo: WORD, fixedPromInfo: BYTE

    EXTRN  InitInterruptController: NEAR, InitControllerOnly: NEAR
    EXTRN  InitInterruptHandlers: NEAR
    EXTRN  BirthInt: FAR
%IF (%systemType EQ 0) THEN (
    EXTRN  InitGPiBVariable: FAR
) FI
    EXTRN  busyStack: BYTE
    EXTRN  CpSetInterrupt: FAR, CpEnableInterrupt: FAR
    EXTRN  cardId: BYTE, cardType: BYTE 
; djm - end

$EJECT



%IF (%testGPiB EQ 1) THEN (

; GPiB Parameters
GPiB_Pattern1	EQU	0ffH
GPiB_Pattern2	EQU	0H

GPiBioSeg 	EQU	0dff8H

Status    EQU	0
AuxCmnd   EQU	6
BusWindow EQU	0cH
BuffOut   EQU	0eH

BuffRdy   EQU	10H

rst		EQU	80H
clrrst    EQU	0H
ton		EQU	8aH
) FI

; Memory mapped I/O addresses and I/O ports


; internal register pointers

umcsReg       EQU 0FFA0H
lmcsReg       EQU 0FFA2H
mpcsReg       EQU 0FFA8H
mmcsReg       EQU 0FFA6H
pacsReg       EQU 0FFA4H
reloReg       EQU 0FFFEH


; initial words

%IF (%systemType EQ 0) THEN (
umcs          EQU 0F038H
lmcs          EQU 03FF8H
mpcs          EQU 090BCH
mmcs          EQU 0C1F9H
pacs          EQU 0003CH

memWrd        EQU 018H
step1Lo       EQU 058H  ;8207 port A
step1Hi       EQU 018H  ;sync for step 2
) FI

%IF (%systemType EQ 1) THEN (
umcs          EQU 0F038H
lmcs          EQU 01FF8H
mpcs          EQU 090BCH
mmcs          EQU 0C1F8H
pacs          EQU 0003CH

memWrd        EQU 018H
step1Lo       EQU 058H  ;8207 port A
step1Hi       EQU 018H  ;sync for step 2
) FI

%IF (%systemType EQ 2) THEN (
memWrd        EQU 018H
step1Lo       EQU 018H  ;8207 port A
step1Hi       EQU 018H  ;sync for step 2
) FI


; manufacturing test prom segment

mnfTestSeg    EQU 0C800H


; other I/O decodes

memSeg        EQU 0C000H
memReg        EQU 00H
sftReg        EQU 01H

on            EQU 00FFH
off           EQU 0000H
wtNum         EQU 003FH

tstReg        EQU 0280H
multbusEnable EQU 0380H
$EJECT

;communication server DMA

palSeg           EQU   0DFE0H
port0St0         EQU   000H
port1St0         EQU   008H
port2St0         EQU   010H
port3St0         EQU   018H

mode8237         EQU   088H
disable8237      EQU   004H

;timer decodes - FS & CS

timer0Mode       EQU   0FF56H
timer0MaxCntA    EQU   0FF52H
timer0MaxCntB    EQU   0FF54H
timer1Mode       EQU   0FF5EH
timer1MaxCntA    EQU   0FF5AH
timer1MaxCntB    EQU   0FF5CH
timer1Count      EQU   0FF58H

timer2Mode       EQU   0FF66H
timer2MaxCnt     EQU   0FF62H
timer2Count      EQU   0FF60H

sysTickMode      EQU   0C001H
sysTickCnt       EQU   12500

%IF (%systemType EQ 0) THEN (
timeOutMode0     EQU   0C001H
) FI

%IF (%systemType EQ 1) THEN (
timeOutMode0     EQU   04000H
) FI

timeOutCnt0      EQU   02H    ; was 0FFH then was 0FH

timeOutMode1     EQU   0C019H
timeOutCnt1      EQU   100    ; was 500 then was 5

;timer decodes - AS

timerCommand     EQU 036H
timerData0       EQU 008H
timerMode        EQU 00EH
timer10msLo      EQU 0D4H
timer10msHi      EQU 030H


; serial port access constants

resetChannel     EQU 018H
txRdy            EQU 004H
rxRdy            EQU 001H
enabled8051      EQU 080H
charRdy8051      EQU 040H

usartSeg         EQU 0DFE4H

aUsartData       EQU 000H
aUsartCommand    EQU 004H
aUsartStatus     EQU 004H

bUsartData       EQU 002H
bUsartCommand    EQU 006H
bUsartStatus     EQU 006H

; 8274 diagnostics serial port detection constants

writeReg1        EQU 000H
pointReg1        EQU 019H
pointReg2        EQU 002H
pattern1         EQU 0A5H
pattern2         EQU 05AH

DATA SEGMENT PUBLIC 'DATA'

diag8274Exists   DB ?

DATA ENDS


CODE SEGMENT PUBLIC 'CODE'
     ASSUME CS:CGROUP, DS:DGROUP

DataFrame     DW DATA        ; segment of data

;  reg, channelA, channelB

usartInitTab  DB    000H, resetChannel, resetChannel
              DB    004H, 04CH, 04CH
              DB    001H, 000H, 000H
              DB    002H, 000H, 000H
              DB    003H, 000H, 0C1H
              DB    005H, 000H, 0EAH
              DB    0FFH
$EJECT

;                     CpInit
;
; This will initialize the 80186 processor,
; 8207 memory controller and the serial ports.
;
; The 80186 is initialized as follows:
;

%IF (%systemType EQ 0) THEN (
;   CS  UPPER  LOWER  SIZE  WAIT EXTWT PURPOSE
;  ----------------------------------------
;  UPPER FFFFF FC000  16K    0   YES    ROM
;  LOWER 3FFFF   0   256K    0   YES    RAM
;  MID   DFFFF C0000  32K    1   YES    I/O
;  PER0-3 --  0(I/O)  128    0   YES    I/O
;  PER4-6 --  0(I/O)  128    2   YES
) FI

%IF (%systemType EQ 1) THEN (
;   CS  UPPER  LOWER  SIZE  WAIT EXTWT PURPOSE
;  ----------------------------------------
;  UPPER FFFFF FF000  16K    0   YES    ROM
;  LOWER 3FFFF   0   128K    0   YES    RAM
;  MID   DFFFF C0000  32K    3   YES    I/O
;  PER    --  0(I/O)  128    0   YES    I/O
) FI


CpInit PROC FAR

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (

;   initialize the 80186

    MOV  DX, lmcsReg
    MOV  AX, lmcs
    OUT  DX, AX                   ; low-memory CS

    MOV  DX, mpcsReg
    MOV  AX, mpcs
    OUT  DX, AX                   ; mid-memory CS

    MOV  DX, mmcsReg
    MOV  AX, mmcs
    OUT  DX, AX                   ; mid-memory CS

    MOV  DX, pacsReg
    MOV  AX, pacs
    OUT  DX, AX                   ; peripheral CS
) FI
$EJECT
;         Memory Related Initialization
;              CpInit (Continued)
;
;     initialize the 8207 memory controller


    MOV  AX, MemSeg
    MOV  DS, AX

    MOV  AL, step1Lo
    MOV  CX, 8

ShiftLo:
    MOV  DS: BYTE PTR SftReg, AL
    SHR  AL, 1
    LOOP ShiftLo                  ; shift in memory

    MOV  AL, step1Hi
    MOV  CX, 8

ShiftHi:
    MOV  DS: BYTE PTR SftReg, AL
    SHR  AL, 1
    LOOP ShiftHi                  ; init word

    MOV  DS: BYTE PTR MemReg, AL  ; turn off 8207 reser

    MOV  CX, wtNum

Delay:
    NOP
    LOOP Delay                    ; wait apprx 100 uSecs
$EJECT
; djm - added the following

;              CpInit (Continued)
;               Set up for Birth

;   set stack to busy stack, so that processing can be done
;   Set up and enable for birth interrupt

    MOV  DS, CS:DataFrame          ; init DS
    MOV  AX, OFFSET busyStack
    ADD  AX, 300                   ; zzz need to make this a constant dcl.
    MOV  SP, AX
    MOV  AX, DS
    MOV  SS, AX                    ; set stack to busy stack, just to have one

    CALL InitControllerOnly        ; only init controller

    MOV  AX, intMessage            ; set up for birth interrupt
    PUSH AX
    MOV  AX, SEG BirthInt
    PUSH AX
    MOV  AX, OFFSET BirthInt
    PUSH AX
    CALL CpSetInterrupt            

    MOV  DX, msgIntReset           ; reset message interrupt latch
    OUT  DX, AX

    MOV  AX, intMessage            ; enable interrupt for birth
    PUSH AX
    MOV  AX, 0
    PUSH AX
    CALL CpEnableInterrupt         

    STI                            ; now wait for birth
Waitloop:                              
    NOP                            ; after birth, control goes elsewhere
    JMP  Waitloop

; djm - end

CpInit ENDP
$EJECT
Continue_Init PROC FAR

;
    MOV  DS, CS:DataFrame
    MOV  BX, commonRamSeg         ; ptr to start of common ram
    MOV  ES, BX

;         Re-init Interrupt Controller and handlers

    MOV  AL, ES: doSelfTest             ; if self test, then do full init
    CMP  AL, 0
    JNE  ContAndDestroy

ContAndDontDestroy:

%IF (%systemType EQ 0) THEN (
    CALL InitGPiBVariable               ; init gpib variables, cludge
                                        ; to get around not initing Prom var mem
) FI
    CALL InitControllerOnly             ; only init controller
    JMP  FinishInit

ContAndDestroy:

    MOV  AX, CS:DataFrame               ; zero out prom variables
    MOV  ES, AX
    XOR  DI, DI
    MOV  AX, DI
    MOV  CX, 1024
    CLD
    REP  STOSW

    CALL InitInterruptController        ; init controller and vectors

FinishInit:

    CALL InitInterruptHandlers
$EJECT
;        Save Card Information

    MOV  BX, commonRamSeg         ; ptr to start of common ram
    MOV  ES, BX

    MOV  AL, ES: bootCardId       ; get card id from birth area
    MOV  DS:cardId, AL            ; save in local memory
    
    ADD  BL, AL                   ; assumes no carry or change to upper byte
    ADD  BL, 8                    ; skip config area
    MOV  DS:consoleSeg, BX        ; save ptr to console area

    XOR  AH, AH
    ADD  AX, commonRamSeg
    MOV  ES, AX

    PUSH ES                       ; save ptr to common ram for later

         ; find memory size and save it

    MOV  AX, 2000h                ; assume first 128kb already exists
    MOV  ES, AX                   ; start at 2000:0
    XOR  BX, BX

    MOV  DX, 1                    ; set counter to count initial 128kb

MemSizeLoop:                      
    MOV  CX, WORD PTR ES:[BX]     ; save current value
    
    MOV  AX, 0A5A5h               ; try with first pattern
    MOV  WORD PTR ES:[BX], AX
    CMP  WORD PTR ES:[BX], AX     ; check value stored with value retrieved
    JNE  EndMemSize               ; if not equal, then memory not there

    MOV  AX, 05A5Ah               ; try again with different pattern
    MOV  WORD PTR ES:[BX], AX
    CMP  WORD PTR ES:[BX], AX     ; check value stored with value retrieved
    JNE  EndMemSize               ; if not equal, then memory not there

    MOV  WORD PTR ES:[BX], CX     ; restore old value
    
    INC  DX                       ; increment memory counter (1 = 128kb)
    CMP  DX, 4                    ; 512kb is maximum to be checked
    JGE  EndMemSize

    MOV  AX, 2000h                ; add next offset, 128kb increment
    MOV  CX, ES                   ; update ptr
    ADD  AX, CX
    MOV  ES, AX
    JMP  MemSizeLoop              ; do it again

EndMemSize:

    MOV  AX, SEG fixedCardInfo    ; get ptr to fixed memory location
    MOV  ES, AX

    MOV  AX, ES: fixedCardInfo    ; get card type information
    MOV  DS: cardType, AH         ; save card type in local Prom vars

    MOV  BX, ES: fixedVersInfo    ; get card version information

    MOV  CL, ES: fixedPromInfo    ; get Prom version information


    POP  ES                       ; restore ptr to common ram table

    MOV  ES: configCardType, AX   ; save card descript in common ram
    MOV  ES: configCardVers, BX
    MOV  ES: configPROMVers, CL
    MOV  ES: configMemSize, DL


;        Timer Related Initialization

; init the timers

%IF (%systemType EQ 0) THEN (
    MOV	 DX, timer1MaxCntA        ;set up time out, timer 1
    MOV  AX, timeOutCnt1
    OUT  DX, AX

    MOV	 DX, timer1Mode
    MOV	 AX, timeOutMode1
    OUT  DX, AX

    MOV	 DX, timer0MaxCntA        ;set up time out, timer 0
    MOV  AX, timeOutCnt0
    OUT  DX, AX
) FI

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
    MOV	 DX, timer0Mode           ;set mode, timer 0
    MOV	 AX, timeOutMode0
    OUT  DX, AX

   	MOV  DX, timer2MaxCnt         ;set up systick
   	MOV  AX, sysTickCnt
	   OUT  DX, AX

    MOV  DX, timer2Mode
    MOV  AX, sysTickMode
    OUT  DX, AX 
) FI

%IF (%systemType EQ 2) THEN (
    MOV  DX, timerMode
    MOV  AX, timerCommand
    OUT  DX, AX                   ; sys tick timer

    MOV  DX, timerData0
    MOV  AX, timer10msLo
    OUT  DX, AX                   ; 10 ms lo value

    MOV  AX, timer10msHi
    OUT  DX, AX                   ; 10 ms hi value
) FI
$EJECT
;
;          InitContinue (Continued)
;   See If Diagnostic 8274 Board Is Attached

    MOV  AX, usartSeg
    MOV  DS, AX

    MOV  AL, pointReg1
    MOV  DS: BYTE PTR bUsartCommand, AL
    MOV  AL, writeReg1
    MOV  DS: BYTE PTR bUsartCommand, AL
    MOV  AL, pointReg2
    MOV  DS: BYTE PTR bUsartCommand, AL
    MOV  AL, pattern1
    MOV  DS: BYTE PTR bUsartCommand, AL
    MOV  AL, pointReg2
    MOV  DS: BYTE PTR bUsartCommand, AL
    MOV  AL, DS: BYTE PTR bUsartStatus
    CMP  AL, pattern1
    JNE  Diag8274NotAttached

    MOV  AL, pointReg2
    MOV  DS: BYTE PTR bUsartCommand, AL
    MOV  AL, pattern2
    MOV  DS: BYTE PTR bUsartCommand, AL
    MOV  AL, pointReg2
    MOV  DS: BYTE PTR bUsartCommand, AL
    MOV  AL, DS: BYTE PTR bUsartStatus
    CMP  AL, pattern2
    JNE  Diag8274NotAttached

Diag8274Attached:
    MOV  BL, TRUE
    JMP  SHORT Diag8274AttachedExit

Diag8274NotAttached:
    MOV  BL, FALSE

Diag8274AttachedExit:
    MOV  AX, DATA
    MOV  DS, AX
    MOV  DS: diag8274Exists, BL
$EJECT
;
;          InitContinue (Continued)
;     Communication Related Initialization

%IF (%systemType EQ 1) THEN (
    MOV  AX, palSeg
    MOV  ES, AX
    XOR  AX, AX
    MOV  ES: BYTE PTR port0St0, AL
    MOV  ES: BYTE PTR port1St0, AL
    MOV  ES: BYTE PTR port2St0, AL
    MOV  ES: BYTE PTR port3St0, AL ; init port pals

    MOV  DX, mode8237
    MOV  AL, disable8237
    OUT  DX, AL                    ; disable 8237
) FI

; init state of the message passing interrupt latch

    MOV  DX, msgIntReset
    MOV  AL, on
    OUT  DX, AL

; init USART for the debug console

    MOV  AX, usartSeg
    MOV  DS, AX
    MOV  ES, AX

; init the 8274 to channel A async

    MOV  AX, SEG usartInitTab
    MOV  ES, AX
    MOV  SI, OFFSET usartInitTab

InitLoop:
    MOV  AL, ES:[SI]
    INC  SI
    CMP  AL, 0FFh
    JE   InitDone

    MOV  DS: BYTE PTR bUsartCommand, AL
    MOV  AH, ES:[SI]
    INC  SI
    MOV  DS: BYTE PTR bUsartCommand, AH

    MOV  DS: BYTE PTR aUsartCommand, AL
    MOV  AH, ES:[SI]
    INC  SI
    MOV  DS: BYTE PTR aUsartCommand, AH
    JMP  InitLoop

InitDone:
%IF (%TestGPiB EQ 1) THEN (
; this is here to determine a problem in gpib not working
; with FASTBOOT

    CALL DiagTest_GPiB
) FI

    RET

Continue_Init ENDP

$EJECT
;                 Cp Key Pressed
;
; This routine checks to see if there is a char
; present in the 8274 input queue or from the 8051.

; NOTE: It is assumed that DS points to the PROM
;       data segment upon entry to this routine

CpKeyPressed PROC NEAR
    PUSH DS
    PUSH ES
    MOV  AX, DS: consoleSeg
    MOV  ES, AX

    TEST DS: diag8274Exists, TRUE
    JZ   CpKeyFrom8051

CpKeyFrom8274:
    MOV  AX, usartSeg
    MOV  DS, AX

    TEST DS: BYTE PTR aUsartStatus, rxRdy
    JNZ  CpKeyWasPressed

CpKeyFrom8051:
    CMP  ES: consoleCardId, 0FFh
    JE   CpKeyNotPressed

    TEST ES: InStatus, 1
    JNZ  CpKeyWasPressed

CpKeyNotPressed:
    MOV  AL, FALSE
    JMP  SHORT CpKeyPressedExit

CpKeyWasPressed:
    MOV  AL, TRUE

CpKeyPressedExit:
    POP  ES
    POP  DS
    RET
CpKeyPressed ENDP
$EJECT

;                     Cp Char In
;
; This routine waits for a character from either
; the 8274 or 8051, then returns that character.

; NOTE: It is assumed that DS points to the PROM
;       data segment upon entry to this routine

CpCharIn PROC NEAR
    PUSH DS
    PUSH ES
    PUSH BX
    MOV  BL, DS: diag8274Exists
    MOV  AX, DS: consoleSeg
    MOV  ES, AX
    MOV  AX, usartSeg
    MOV  DS, AX

CharFrom8274:
    TEST BL, TRUE
    JZ   CharFrom8051

    TEST DS: BYTE PTR aUsartStatus, rxRdy
    JZ   CharFrom8051

    MOV  AL, DS: BYTE PTR aUsartData
    JMP  SHORT CpCharInExit

CharFrom8051:
    CMP  ES: consoleCardId, 0FFh
    JE   CharFrom8274

    TEST ES: InStatus, 1
    JZ   CharFrom8274
    
    MOV  AL, ES: InData
    XOR  AH, AH
    MOV  ES: InStatus, AH

CpCharInExit:
    XOR  AH, AH
    POP  BX
    POP  ES
    POP  DS
    RET
CpCharIn ENDP
$EJECT

;                    Cp Char Out
;
; This routine sends a character out both to the
; the 8274 chip and the 8051 diagnostic processor.

; NOTE: It is assumed that DS points to the PROM
;       data segment upon entry to this routine

CpCharOut PROC NEAR
    PUSH DS
    PUSH ES

    PUSH AX
    TEST DS: diag8274Exists, TRUE ; Results of
    MOV  AX, DS: consoleSeg       ; zero flag can't
    MOV  ES, AX                   ; change until
    MOV  AX, usartSeg             ; the test below
    MOV  DS, AX                   ; 
    POP  AX                       ; (JZ WaitFor8051)
    JZ   WaitFor8051

WaitFor8274:
    TEST DS: BYTE PTR aUsartStatus, txRdy
    JZ   WaitFor8274
    MOV  DS: BYTE PTR aUsartData, AL

WaitFor8051:
    CMP  ES: consoleCardId, 0FFh
    JE   CpCharOutExit

    TEST ES: OutStatus, 1
    JZ   Give8051TheCharacter
    CALL CpDelay1Millisecond
    JMP  SHORT WaitFor8051

Give8051TheCharacter:
    MOV  ES: OutData, AL
    MOV  AH, 1
    MOV  ES: OutStatus, AH

CpCharOutExit:
    POP  ES
    POP  DS
    RET
CpCharOut ENDP
$EJECT

;                   Con Char Out
;
; This is the long call interface to CpCharOut

char EQU BYTE PTR [BP+8]

ConCharOut PROC FAR
    PUSH DS
    MOV  AX, DATA
    MOV  DS, AX
    PUSH BP
    MOV  BP, SP

    MOV  AL, char
    CALL CpCharOut

    MOV  SP, BP
    POP  BP
    POP  DS
    RET  2
ConCharOut ENDP

PURGE char
$EJECT

;
;                   Con Line Out
;
; This sends a string of characters to the console


lenMsg EQU WORD  PTR [BP+8]
pMsg   EQU DWORD PTR [BP+10]

ConLineOut PROC FAR
    PUSH DS
    MOV  AX, DATA
    MOV  DS, AX
    PUSH BP
    MOV  BP,SP

    LES  DI, pMsg
    MOV  CX, lenMsg
    JCXZ ConLineOutExit

ConLineOutLoop:
    MOV  AX, ES:[DI]
    PUSH ES
    PUSH CX
    PUSH DI
    CALL CpCharOut
    POP  DI
    POP  CX
    POP  ES
    INC  DI
    LOOP ConLineOutLoop

ConLineOutExit:
    MOV  SP, BP
    POP  BP
    POP  DS
    RET  6
ConLineOut ENDP

PURGE lenMsg, pMsg

%IF (%TestGPiB EQ 1) THEN (

DiagTest_GPiB	PROC	NEAR

	mov	AX, GPiBioSeg		;setup GPiB io seg
	mov	ES, AX
	mov	AL, GPiB_Pattern1	;byte to write to bus

GPiB_Loop:
	mov	DI, AuxCmnd		;write to command reg
	mov	ES:Byte Ptr[DI], rst ;reset chip
	mov	ES:Byte Ptr[DI], clrrst ;reset reset
	mov	CL, 78H			;delay for reset to

	shr	CL, CL			;complete
	mov	ES:Byte Ptr[DI], ton ;talk on
	mov	CX, 0ffffH		;timeout
	mov	DI, Status		;check for buffer rdy

GPiB_Loop1:
	test	ES:Byte Ptr[DI], BuffRdy ;ready for byte?
	je	SendByte_1		;yes
	loop	GPiB_Loop1		;loop til ready
	jmp	GPiB_Error		;chip bad

SendByte_1:
	mov	DI, BuffOut		;write to data buff
	mov	ES:Byte Ptr[DI], AL ;write test pattern
	mov	DI, BusWindow		;read data bus
	cmp	ES:Byte Ptr[DI], AL ;same?
	je	Pattern_Change		;yes
	jmp	GPiB_Error		;no, error

Pattern_Change:
	cmp	AL, GPiB_Pattern2	;done with test?
	jne	Second_Pattern		;no
	RET                 ;next test

Second_Pattern:
	mov	AL, GPiB_Pattern2	;set second pattern
	jmp	GPiB_Loop			;go again

GPiB_Error:

 RET

DiagTest_GPiB	ENDP

) FI

CODE ENDS
$EJECT

; The 80186 will jump here after a reset

Restart SEGMENT AT (0FFFFH)

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
    MOV  DX, umcsReg
    MOV  AX, umcs
    OUT  DX, AX
) FI
    JMP  CpInit

Restart ENDS

    END
